clear;
clc;
fullScriptPath = matlab.desktop.editor.getActiveFilename();
[folderPath, ~, ~] = fileparts(fullScriptPath);
%% FILE1
%nomefile
file1 = 'C2_2025-07-22_14-56-35.txt';
% Define the names of the files you want to read
filename1 = fullfile(folderPath, file1);
% Importa i dati
data_import_1 = importdata(filename1,'\t');
% Visualizza i dati
data1=data_import_1.data(5:end,:);
disp(data_import_1);

%% GRAFICI

figure(1)
% quota

subplot(4,1,1)
plot(data1(:,1)-data1(1,1)-20,data1(:,5),"--k", 'LineWidth', 1.5)
hold on
plot(data1(:,1)-data1(1,1)-20,data1(:,4),"k", 'LineWidth', 1.5)
hold on
xlabel('time [s]');
ylabel('altitude [feet]');
legend('com','response', 'Location', 'northeast');
xlim([0 80])
pbaspect([5 1 1]) % Aspect ratio X:Y:Z
set(gcf, 'Position', [100, 100, 800, 800]) % [x, y, width, height]
ylim([5900 6900])
grid on

subplot(4,1,2)
plot(data1(:,1)-data1(1,1)-20,data1(:,6),"k", 'LineWidth', 1.5)
grid on
xlabel('time [s]');
ylabel('pitch [deg]');
xlim([0 80])
pbaspect([5 1 1]) % Aspect ratio X:Y:Z

subplot(4,1,3)
plot(data1(:,1)-data1(1,1)-20,data1(:,12),"k", 'LineWidth', 1.5)
grid on
xlabel('time [s]');
ylabel('\deltae [deg]');
xlim([0 80])
pbaspect([5 1 1]) % Aspect ratio X:Y:Z
ylim([-20 27])

subplot(4,1,4)
plot(data1(:,1)-data1(1,1)-20,data1(:,25)/9.8*0.3048,"k", 'LineWidth', 1.5)
grid on
xlabel('time [s]');
ylabel('acceleration [g]');
xlim([0 80])
pbaspect([5 1 1]) % Aspect ratio X:Y:Z
ylim([-9 9])







